#include <stdio.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "test_common.h"
#include "mx__driver_interface.h"
#include "mx_io.h"
#include "mx__lib_types.h"
#include "mx_byteswap.h"

#define BUFF_LEN (512 * 1024 * 1024)

void master(struct host_entry *hosts, mx_endpoint_t ep)
{
  mx_return_t ret;
  mx_segment_t seg;
  mx_request_t req;
  mx_status_t status;
  uint32_t r;
  char *buff;
  mx_direct_get_t xget;
  int rc;
  uint32_t s_board;
  uint32_t s_eid;
  uint64_t s_va;
  char msg[(sizeof(uint32_t) +  /* board number */
	    sizeof(uint32_t) +  /* eid */
	    sizeof(uint64_t))]; /* va */

  buff = malloc(BUFF_LEN + 0);
  if (buff == NULL) {
    printf("malloc failed.\n");
    FAIL();
  }
  buff += 0;
  memset(buff, 0, BUFF_LEN);

  printf("I'm the master\n");

  /* Get info from slave. */
  seg.segment_ptr = msg;
  seg.segment_length = sizeof (msg);
  ret = mx_irecv(ep, &seg, 1, THE_MATCH, MX_MATCH_MASK_NONE, NULL, &req);
  printf("waiting for slave to give us information\n");
  fflush(stdout);
  ret = mx_wait(ep, &req, MX_INFINITE, &status, &r);
  printf("got message from slave\n");
  memcpy(&s_board, msg, sizeof (uint32_t));
  memcpy(&s_eid, msg + sizeof (uint32_t), sizeof (uint32_t));
  memcpy(&s_va, msg + sizeof (uint32_t)*2, sizeof (uint64_t));
  s_board = ntohl(s_board);
  s_eid = ntohl(s_eid);
  s_va = mx_ntohll(s_va);
  printf("s_board = %u\n", s_board);
  printf("s_eid = %u\n", s_eid);
  printf("s_va = %"PRIu64"\n", s_va);

  if (1) {
  xget.dst_va = (uintptr_t)buff;
  xget.src_va = (uintptr_t)s_va;
  xget.length = BUFF_LEN;
  xget.src_endpt = s_eid;
  xget.src_board_num = s_board;
  rc = mx__direct_get(ep->handle, &xget);
  if (rc != 0) {
    fprintf(stderr, "mx__direct_get failed with %d\n", rc);
  }
  else {
    printf("checking data...\n");
    check_data_int(buff, BUFF_LEN, 0);
    printf("finished checking data...\n");
  }
  }
  printf("exiting...\n");

  free(buff);

  /* Tell slave we're done. */
  ret = mx_isend(ep, &seg, 1, hosts[1].addr, THE_MATCH, NULL, &req);
  ret = mx_wait(ep, &req, MX_INFINITE, &status, &r);
}

void slave(struct host_entry *hosts, mx_endpoint_t ep)
{
  mx_return_t ret;
  mx_segment_t seg;
  mx_request_t req;
  mx_status_t status;
  uint32_t r;
  char *buff;
  uint32_t s_board;
  uint32_t s_eid;
  uint64_t s_va;
  char msg[(sizeof(uint32_t) +  /* board number */
	    sizeof(uint32_t) +  /* eid */
	    sizeof(uint64_t))]; /* va */

  buff = malloc(BUFF_LEN);
  if (buff == NULL) {
    fprintf(stderr, "couldn't get buffer\n");
    FAIL();
  }
  fill_data_int(buff, BUFF_LEN);

  printf("I'm the slave\n");
  printf("my buffer address is %p\n", buff);

  s_board = 0;
  s_eid = hosts[1].eid;
  s_va = (uint64_t)(uintptr_t)buff;
  printf("s_board = %u\n", s_board);
  printf("s_eid = %u\n", s_eid);
  printf("s_va = %"PRIu64"\n", s_va);
  s_board = htonl(s_board);
  s_eid = htonl(s_eid);
  s_va = mx_htonll(s_va);
  memcpy(msg, &s_board, sizeof (uint32_t));
  memcpy(msg + sizeof (uint32_t), &s_eid, sizeof (uint32_t));
  memcpy(msg + sizeof (uint32_t)*2, &s_va, sizeof (uint64_t));

  seg.segment_ptr = msg;
  seg.segment_length = sizeof (msg);
  ret = mx_isend(ep, &seg, 1, hosts[0].addr, THE_MATCH, NULL, &req);
  ret = mx_wait(ep, &req, MX_INFINITE, &status, &r);

  printf("waiting for master to tell us we're done\n");
  fflush(stdout);

  ret = mx_irecv(ep, &seg, 1, THE_MATCH, MX_MATCH_MASK_NONE, NULL, &req);
  ret = mx_wait(ep, &req, MX_INFINITE, &status, &r);

  free(buff);
}

int main(int argc, char **argv)
{
  int my_rank;
  char *filename;
  struct host_entry *hosts;
  int count;
  mx_endpoint_t ep = NULL;
  struct host_entry host;

 
  get_rank(argc, argv, &my_rank);
  get_filename(&filename);
  get_hosts(filename, &hosts, &count);
  if (count < 2) {
    printf("This test needs 2 hosts, got %d.\n", count);
    FAIL();
  }
  if (strcmp(hosts[0].mx_name, hosts[1].mx_name) != 0) {
    printf("direct_get only works on local hosts.\n");
    FAIL();
  }
  get_ep(hosts, my_rank, &ep);
  if (1) {
  connect_hosts(hosts, 2, my_rank, ep); /* 2 since we know we're pt2pt. */

  if (my_rank == 0) {
    master(hosts, ep);
  }
  else {
    slave(hosts, ep);
  }

  release_ep(ep);
  }
  PASS();
  return 0;
}
